/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

//edit of http://glslsandbox.com/e#22535.0

#ifdef GL_ES
precision mediump float;
#endif

vec2 resolution = iResolution;
float time = iGlobalTime/2.0;

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
   vec2 p=(2.*fragCoord.xy-resolution.xy) / resolution.y;
	float l = length(p);
	vec2 rm = vec2( acos( cos(time/1.-l) * l ), asin( sin(time/1.-l) * .5 * l ) / dot(p,p*l));
	p = vec2( p.x*rm.x - p.y*rm.y, p.x*rm.y - p.y*rm.x / 1.-dot(p,p/l));
		
   float b=abs(l-2.0)+(cos(15.*(atan(p.x,p.x*dot(rm,p)))))*.13;

   fragColor = vec4(b,abs(.8-b),1.-b, 1.4 );


}

// main added by TheEmu.

void main (void) {
  mainImage ( gl_FragColor, gl_FragCoord.xy );
}